# Script to setup installation of Python modules by writing a simple script. This script needs to be in the
# directory containing the Blender binary/executable, along with the font_manager.py file.
# Run this script from that directory with :
#./blender --background --python MakeFRELLEDScript.py
# This will produce a file "InstallPythonModules.txt", containing the commands needed to install the Python
# modules and configure Blender for running FRELLED.

import sys
import os
import platform

# Get current directory
abspath  = os.path.abspath(__file__)
curdname = os.path.dirname(abspath)

# Get the user's home directory
udname = os.path.expanduser('~')

print('Creating installation setup file...')

# Need to know the operating system, as Windows prefers backslashes whereas Linux and Mac insist on forward
# slashes when setting directories. They also install things to different locations
thisos = platform.system()

# Get the directory where Blender's Python is installed
bpydir = sys.exec_prefix

# Create an installation script file
InstallPyModules = open('InstallPyModules.txt','w')
InstallPyModules.write('# README. These commands will install the necessary Python modules in Blender\'s internal Python'+'\n')
InstallPyModules.write('# installation, using Pip. Any other Python installations will not be affected.'+'\n')
InstallPyModules.write('\n')
InstallPyModules.write('# INSTRUCTIONS. Copy and paste all commands below into a terminal (or on Windows a PowerShell window'+'\n') 
InstallPyModules.write('# may be better). Run them sequentially to check for any bugs.'+'\n')
InstallPyModules.write('# Note this file can be easier to read with word wrapping disabled !'+'\n')
InstallPyModules.write('\n')
InstallPyModules.write('\n')

InstallPyModules.write('# 1) PYTHON SETUP :'+'\n')

# A few differences between Windows and Linux. Windows uses backslashes as directory separators, which in
# Python is an escape character so has to be written twice to produce a single backslash in the output file.
# Linux uses forward slashes, which is treated as a normal character.
# The Windows Python executable is simply called "python.exe" and the ".exe" does not need to be provided to
# run it. The Linux binary is "python3.5m" and must be written in full to run it.
# Mac has the same Python binary in the same location as Linux.
# On Windows pip is in a fixed subddirectory location. On Linux (and Mac ?) it goes in /home/USER/.local/bin

# For reference :
# bpydir : route directory of Blender's Python
# pydir : directory of Python binary
# moddir : directory where new Python modules will be installed
# pipdir : directory of pip binary
# pybin : python.exe on Windows, python3.5m on Linux and Mac
# curdname : directory where the script is being run, which should be where the Blender binary is located
# udname : user's home directory

if thisos == 'Windows':
   pybin = 'python.exe'
   moddir = bpydir+"\\lib\\site-packages"
   pydir =  bpydir+"\\bin"
   pipdir = bpydir+"\\scripts"
  
if thisos == 'Linux':
   pybin = 'python3.5m'
   moddir = bpydir+"/lib/python3.5/site-packages"
   pydir =  bpydir+"/bin"
   pipdir = bpydir+"/bin"

# Mac
if thisos == 'Darwin':
   pybin = 'python3.5m'
   moddir = bpydir+"/lib/python3.5/site-packages"
   pydir  = bpydir+"/bin"
   pipdir  = bpydir+"/bin"
   # Can't remember where I got this from, the above should work
   #pipdir = bpydir+"/lib/python3.5/site-packages"


# Now we can write the commands to :
# Change to pydir
InstallPyModules.write('cd "'+pydir+'"'+'\n')
# Run Python to setup pip
InstallPyModules.write('./'+pybin+' -m ensurepip'+'\n')
# Change to directory where the pip binary should be is located
InstallPyModules.write('cd "'+pipdir+'"'+'\n')
InstallPyModules.write('\n')

# On Windows (NOT SURE ABOUT LINUX/MAC), "ensurepip" only produces the pip files in the scripts directory if the user doesn't have
# their own pip installation. So first we need to check that the files exist where expected :
needtocopyfiles = False
if thisos == 'Windows':
	InstallPyModules.write('# Windows users - if you already have pip installed, "ensurepip" won\'t create the pip files where'+'\n')
	InstallPyModules.write('# they\'re supposed to be. Check the pip.exe file is here with :'+'\n')
	InstallPyModules.write('ls'+'\n')
	InstallPyModules.write('# if pip.exe is listed here, skip ahead to the bit about upgrading pip, below the "WARNING" message.'+'\n')
	InstallPyModules.write('# If you do NOT see pip.exe listed, try the following :'+'\n')
	InstallPyModules.write('cd "'+udname+'\\AppData\Roaming\Python\Python35\Scripts\\"'+'\n')
	InstallPyModules.write('ls'+'\n')
	InstallPyModules.write('# If pip.exe is listed here, copy it to the correct directory :'+'\n')
	InstallPyModules.write('cp -Force "'+udname+'\\AppData\Roaming\Python\Python35\Scripts\\pip.exe" "'+pipdir+'\\"'+'\n')
	InstallPyModules.write('cp -Force "'+udname+'\\AppData\Roaming\Python\Python35\Scripts\\pip3.exe" "'+pipdir+'\\"'+'\n')
	InstallPyModules.write('cp -Force "'+udname+'\\AppData\Roaming\Python\Python35\Scripts\\pip3.5.exe" "'+pipdir+'\\"'+'\n')
	InstallPyModules.write('cd "'+pipdir+'"'+'\n')
	InstallPyModules.write('\n')
	InstallPyModules.write('# WARNING - you can only proceed with the rest of the script provided the pip files have been successfully'+'\n')
	InstallPyModules.write('# created in moved to the /BLENDER/2.79/python/Scripts directory	!'+'\n')
	InstallPyModules.write('\n')

# Upgrade pip. --user gives permissions necessary to access required folders
# Should definitely work on both Windows on Linux but not necessarily Macs
InstallPyModules.write('# To ensure all modules are installed correctly, first upgrade pip itself :'+'\n')
if thisos == 'Darwin':
   InstallPyModules.write('# Mac users : try upgrading pip in the conventional way first :'+'\n')

# Upgrade pip on all OSs
InstallPyModules.write('./pip3 install --upgrade pip --user'+'\n')

if thisos == 'Darwin':
   InstallPyModules.write('# If that gives an error, try the following :'+'\n')
   InstallPyModules.write('curl https://bootstrap.pypa.io/pip/3.5/get-pip.py | '+'"'+pydir+'/'+pybin+'"'+'\n')
   InstallPyModules.write('\n')
	
# Here, MIGHT need to copy the files again on Windows. Not sure.

InstallPyModules.write('\n')
InstallPyModules.write('\n')

InstallPyModules.write('# 2) INSTALL EXTRA PYTHON MODULES :'+'\n')
InstallPyModules.write('# *** WARNING !!! ***'+'\n')
InstallPyModules.write('# ONLY PROCEED IF ALL OF THE ABOVE COMMANDS GAVE NO ERRORS !'+'\n')
InstallPyModules.write('# IF YOU IGNORE THIS WARNING YOU RISK ETERNAL DAMNATION AND MILD INCOVENIENCE !'+'\n')
InstallPyModules.write('# (Messages about requirement being already satisfied can be ignored)'+'\n')

# "Wheel" is necessary for installing certain other modules
InstallPyModules.write('./pip3 install --target="'+moddir+'" wheel'+'\n')
# Use --upgrade switch for astropy to ensure numpy will be updated
InstallPyModules.write('./pip3 install --target="'+moddir+'" matplotlib==3.0.3 --upgrade'+'\n')

# Copy a matplotlib file to fix a silly bug
if thisos == 'Windows':
	InstallPyModules.write('mv -Force "'+curdname+'\\font_manager.py" '+'"'+moddir+'\matplotlib\"'+'\n')

if thisos == 'Linux':	# NOTE - NOT SURE ABOUT MAC
	InstallPyModules.write('mv -f "'+curdname+'/font_manager.py" '+'"'+moddir+'/matplotlib/"'+'\n')	
	
# Proceed with additional modules
InstallPyModules.write('./pip3 install --target="'+moddir+'" astropy==3.2.3 --upgrade'+'\n')
InstallPyModules.write('./pip3 install --target="'+moddir+'" scipy==1.4.1 --upgrade'+'\n')
InstallPyModules.write('./pip3 install --target="'+moddir+'" scikit-image==0.15.0 --upgrade'+'\n')
InstallPyModules.write('./pip3 install --target="'+moddir+'" Pillow==7.2.0 --upgrade'+'\n')
InstallPyModules.write('./pip3 install --target="'+moddir+'" spectral-cube==0.4.5 --upgrade'+'\n')
InstallPyModules.write('./pip3 install --target="'+moddir+'" parmap==1.5.2 --upgrade'+'\n')
InstallPyModules.write('\n')
InstallPyModules.write('\n')

 
InstallPyModules.write('# 3) CONFIGURE BLENDER FOR FRELLED:'+'\n')
InstallPyModules.write('# To proceed further, unpack the FRELLEDInstallationPackages.zip file into the directory containing'+'\n')
InstallPyModules.write('# the Blender executable or binary file. All three files should be in the same directory as the'+'\n')
InstallPyModules.write('# Blender file itself.'+'\n')
InstallPyModules.write('cd "'+curdname+'"'+'\n')
if thisos == 'Windows':
	InstallPyModules.write('./blender.exe -y --enable-autoexec Setup.blend'+'\n')
if thisos == 'Linux':
	InstallPyModules.write('./blender -y --enable-autoexec Setup.blend'+'\n')
	
InstallPyModules.write('\n')
InstallPyModules.write('\n')

InstallPyModules.write('# 4) ACCESSING BLENDER :'+'\n')	
if thisos == 'Darwin' or thisos == 'Linux':
	InstallPyModules.write("# It's strongly recommended to set up an alias command to run this version of blender : "+'\n')
	InstallPyModules.write('alias blender='+curdname+'/blender --enable-new-depsgraph'+'\n')
	InstallPyModules.write('# Add the above command to your .bashrc file to make this command permanent.'+'\n')
	InstallPyModules.write('# (Unsure what this means ? Have a look here : https://linuxize.com/post/how-to-create-bash-aliases/'+'\n')
	InstallPyModules.write('# You can also create a graphical shortcut (symbolic link) to Blender with :'+'\n')
	InstallPyModules.write('ln -s '+curdname+'/blender'+' ~/Desktop/blender.lnk'+'\n')
	InstallPyModules.write("# And you can also run Blender's version of Python directly (without running Blender itself) with"+'\n')
	InstallPyModules.write("# the command:"+'\n')
	InstallPyModules.write('bpydir+/bin/python3.5m')
	
if thisos == 'Windows':
	InstallPyModules.write('# Create a shortcut to Blender by the following :'+'\n')
	InstallPyModules.write('# 1) Right-click on the blender.exe file and choose "Create Shortcut"'+'\n')	
	InstallPyModules.write('# 2) Right-click on the shortcut and choose "Properties"'+'\n')
	InstallPyModules.write('# 3) Replace the entry in the "Target" field with the following :'+'\n')
	InstallPyModules.write('# "'+curdname+'\\blender.exe"'+' --start-console --enable-new-depsgraph'+'\n')
	InstallPyModules.write("# That's it ! You can move and rename the shortcut however you like.")
	
InstallPyModules.write('\n')
InstallPyModules.write('\n')

InstallPyModules.write('# 5) RUNNING FRELLED :'+'\n')
InstallPyModules.write('# Open the version of Blender using the command, symbolic link or shortcut you created in step 4.'+'\n')
InstallPyModules.write('# For example on Mac and Linux just type "blender" into a terminal. On Windows, double-click the'+'\n')
InstallPyModules.write('# shortcut icon.'+'\n')
InstallPyModules.write("# Alternatively, you can run the .exe or binary file directly from Blender's installation directory,"+'\n')
InstallPyModules.write("# but rememebr to use the '--enable-new-depsgraph' switch or you'll get some silly warning messages."+'\n')
InstallPyModules.write('# Once Blender is open, use the top-left "File" menu to open the FRELLED.blend file.'+'\n')

InstallPyModules.close()

print('Done ! Created InstallPyModules.txt in the current directory.')
print('Run the commands in that file to install the necessary Python modules and setup Blender.')
